#ifndef __DEBUG_HLSL__
#define __DEBUG_HLSL__

#if FXC_COMPILE
#include "FXCCompile.hlsl"
#endif

#ifndef ShowDebugValue
	#define ShowDebugValue 0
#endif

#ifndef ShowDiffuseMap
	#define ShowDiffuseMap 0
#endif
#ifndef ShowColorMap
	#define ShowColorMap 0
#endif
#ifndef ShowDetailMap
	#define ShowDetailMap 0
#endif
#ifndef ShowOcclusion
	#define ShowOcclusion 0
#endif
#ifndef ShowFullDetail
	#define ShowFullDetail 0
#endif
#ifndef ShowNormalMap
	#define ShowNormalMap 0
#endif
#ifndef ShowVertexNormal
	#define ShowVertexNormal 0
#endif
#ifndef ShowFinalNormal
	#define ShowFinalNormal 0
#endif
#ifndef ShowSpecMap
	#define ShowSpecMap 0
#endif
#ifndef ShowGlowMap
	#define ShowGlowMap 0
#endif
#ifndef ShowCubeMap
	#define ShowCubeMap 0
#endif
#ifndef ShowAmbientLighting
	#define ShowAmbientLighting 0
#endif
#ifndef ShowDiffuseLighting
	#define ShowDiffuseLighting 0
#endif
#ifndef ShowSpecularLighting
	#define ShowSpecularLighting 0
#endif
#ifndef ShowFresnelLighting
	#define ShowFresnelLighting 0
#endif
#ifndef ShowFresnelCoeff
	#define ShowFresnelCoeff 0
#endif

//warning: lighting equations are not expected to use this values
#ifndef ShowAmbientLighting_Plus_DiffuseLighting
	#define ShowAmbientLighting_Plus_DiffuseLighting 0
#endif
#ifndef ShowAmbientLighting_Plus_DiffuseLighting_With_DiffuseMap
	#define ShowAmbientLighting_Plus_DiffuseLighting_With_DiffuseMap 0
#endif

//fog on/off

float3 Debug(float3 vCurValue, float3 vBaseSampler, float3 vColorSampler, float3 vDetailSampler, float fOcclusion, float3 vFullDetail, float3 vNormalSampler, float3 vVertexNormal, float3 vFinalNormal, float3 vSpecSampler, float3 vGlowSampler, float3 vCubeSampler, float3 vAmbientLighting, float3 vDiffuseLighting, float3 vSpecularLighting, float3 vFresnelLighting, float fFresnelCoeff)
{	
#if ShowDiffuseMap
	return vBaseSampler;
#endif

#if ShowColorMap
	return vColorSampler;
#endif

#if ShowDetailMap
	return vDetailSampler;
#endif

#if ShowOcclusion
	return fOcclusion.xxx;
#endif

#if ShowFullDetail
	return vFullDetail;
#endif

#if ShowNormalMap
	return vNormalSampler * 0.5f + 0.5f;
#endif

#if ShowVertexNormal
	return vVertexNormal * 0.5f + 0.5f;
#endif

#if ShowFinalNormal
	return vFinalNormal * 0.5f + 0.5f;
#endif

#if ShowSpecMap
    return vSpecSampler;
#endif

#if ShowGlowMap
    return vGlowSampler;
#endif

#if ShowCubeMap
	return vCubeSampler;
#endif

#if ShowAmbientLighting
    return vAmbientLighting;
#endif

#if ShowDiffuseLighting
    return vDiffuseLighting;
#endif

#if ShowSpecularLighting
	return vSpecularLighting;
#endif

#if ShowFresnelLighting
	return vFresnelLighting;
#endif

#if ShowFresnelCoeff
	return fFresnelCoeff.xxx;
#endif

#if ShowAmbientLighting_Plus_DiffuseLighting
	return (vAmbientLighting + vDiffuseLighting);
#endif

#if ShowAmbientLighting_Plus_DiffuseLighting_With_DiffuseMap
	return vBaseSampler * ( vAmbientLighting + vDiffuseLighting );
#endif

    return vCurValue;
}

#define DebugValues(value) \
    Debug(value, vBaseSampler, vColorSampler, vDetailSampler, fOcclusion, vFullDetail, vNormalSampler, vVertexNormal, vNormal, vSpecSampler, vGlowSampler, vCubeSampler, vAmbientLighting, vDiffuseLighting, vSpecularLighting, vFresnelLighting, fFresnelCoeff )

#endif // __DEBUG_HLSL__