#ifndef __DIFFUSESH__HLSL__
#define __DIFFUSESH__HLSL__

// ----------------------------------------------------------------
// SH:

#if NOT_GB_VIEWER    
#define UseControllerSH 0
#else
#define UseControllerSH 1
#endif

#if UseControllerSH
float4 cAr < bool hidden = true; >;
float4 cAg < bool hidden = true; >;
float4 cAb < bool hidden = true; >;
float4 cBr < bool hidden = true; >;
float4 cBg < bool hidden = true; >;
float4 cBb < bool hidden = true; >;
float4 cC < bool hidden = true; >;
#endif

const float4 DomelightAr : GLOBAL;
const float4 DomelightAg : GLOBAL;
const float4 DomelightAb : GLOBAL;
const float4 DomelightBr : GLOBAL;
const float4 DomelightBg : GLOBAL;
const float4 DomelightBb : GLOBAL;
const float4 DomelightC : GLOBAL;

float3 ComputeDiffuseSH(float3 vNormal, float4 _cAr, float4 _cAg, float4 _cAb, float4 _cBr, float4 _cBg, float4 _cBb, float4 _cC)
{
    float4 vExtendedNormal = float4(vNormal,1);
    float3 x1, x2, x3;
    // Linear + constant polynomial terms
    x1.r = dot(_cAr,vExtendedNormal);
    x1.g = dot(_cAg,vExtendedNormal);
    x1.b = dot(_cAb,vExtendedNormal);

    // 4 of the quadratic polynomials
    float4 vB = vExtendedNormal.xyzz * vExtendedNormal.yzzx;   
    x2.r = dot(_cBr,vB);
    x2.g = dot(_cBg,vB);
    x2.b = dot(_cBb,vB);

    // Final quadratic polynomial
    float vC = vExtendedNormal.x*vExtendedNormal.x - vExtendedNormal.y*vExtendedNormal.y;
    x3 = _cC.rgb * vC;    
    return  (x1 + x2 + x3);

}

float3 ComputeDiffuseSH(float3 vNormal)
{
	#if UseControllerSH
	return(ComputeDiffuseSH(vNormal, DomelightAr + cAr, DomelightAg + cAg, DomelightAb + cAb, DomelightBr + cBr, DomelightBg + cBb, DomelightBb + cBb, DomelightC + cC));
	#else
	return(ComputeDiffuseSH(vNormal, DomelightAr, DomelightAg, DomelightAb, DomelightBr, DomelightBg, DomelightBb, DomelightC));
	#endif
}

#endif
