/***********************************************************************************************************
*
***********************************************************************************************************/
#ifndef CFXLIBRARY_COMPILE
#include "FXCCompile.hlsl"
#endif

#ifdef NOT_GB_VIEWER
	#define UseNewChannel 1
#else
	#define UseNewChannel 0
#endif

#define PhongIsolated 0

/***********************************************************************************************************
*
***********************************************************************************************************/
#define DeclareUniqueCode 1
#include "Phong.hlsl"
#undef DeclareUniqueCode

/***********************************************************************************************************
*
***********************************************************************************************************/
#define DeclareUniqueCode 0
#define UseShader30 1
#include "Phong.hlsl"
#undef UseShader30
#define UseShader30 0
#include "Phong.hlsl"
#undef UseShader30
#undef DeclareUniqueCode

#undef PhongIsolated

/***********************************************************************************************************
*
***********************************************************************************************************/
technique Phong_30
<
string ShaderName           = "Phong";
string classname            = "SHMaterial";
string NBTMethod            = "ATI";
int NBTSourceUV             = 0;
bool UsesNiRenderState      = true;
bool UsesNiSamplerState     = true;
int BonesPerPartition       = 60;
>
{
    pass P0
    {
        VertexShader    = compile vs_3_0 VSMain30();
        PixelShader     = compile ps_3_0 PSMain30();
    }
}

/***********************************************************************************************************
*
***********************************************************************************************************/
technique Phong_20
<
string ShaderName           = "Phong";
string classname            = "SHMaterial";
string NBTMethod            = "ATI";
int NBTSourceUV             = 0;
bool UsesNiRenderState      = true;
bool UsesNiSamplerState     = true;
int BonesPerPartition       = 60;
>
{
    pass P0
    {
        VertexShader    = compile vs_2_0 VSMain20();
        PixelShader     = compile ps_2_0 PSMain20();
    }
}
