#ifndef __TEXTURES__HLSL__
#define __TEXTURES__HLSL__

float2 GetUV(float2 vTexCoord, uniform float4x3 mTransform, uniform bool bUseTransfom)
{
    float4 vRes = float4(vTexCoord,0,1);
    if (bUseTransfom)
    {
        vRes.xyz = mul(vRes, mTransform);
    }
    return vRes.xy;
}

float4 tex1D(uniform sampler1D s, float vTex, uniform bool b, uniform float4 vDefault = float4(1,1,1,1))
{
    float4 vRet = vDefault;
    if (b)
    {
        vRet = tex1D(s, vTex);
    }
    return vRet;
}

float4 tex2D(uniform sampler2D s, float2 vTex, uniform bool b, uniform float4 vDefault = float4(1,1,1,1))
{
    float4 vRet = vDefault;
    if (b)
    {
        vRet = tex2D(s, vTex);
    }
    return vRet;
}

float4 texCUBE(uniform samplerCUBE s, float3 vTex, uniform bool b, uniform float4 vDefault = float4(1,1,1,1))
{
    float4 vRet = vDefault;
    if (b)
    {
        vRet = texCUBE(s, vTex);
    }
    return vRet;
}

#endif // __TEXTURES__HLSL__