#ifndef __UNIFORMS__HLSL__
#define __UNIFORMS__HLSL__

const float2    AmbiantFresnelScale            : GLOBAL;
const float3    FogColor                       : GLOBAL;
const float3    FogDistanceAndLength           : GLOBAL;
const float     BlendWeatherValue              : GLOBAL;
const float4    Time_CosTime_SinTime_TanTime   : GLOBAL;
const float2    CameraNearFar                  : GLOBAL;
const float4    PrecipitationLightDirAndDensity         : GLOBAL;
const float3    BackLightColor                 : GLOBAL;

#if FXC_COMPILE
#include "FXCCompile.hlsl"
#endif

float4x3 TexTransformBase : TEXTRANSFORMBASE;
float4x3 TexTransformDecal : TEXTRANSFORMDECAL;

float4x3 World : WORLD;
float4x3 InvWorld : INVWORLD;

float4x4 View : VIEW;
float4x4 Proj : PROJECTION;
float4x4 ViewProj : VIEWPROJECTION;
float4x4 InvView : INVVIEW;
float4x4 InvWorldView : INVWORLDVIEW;
float4x4 InvViewProj : INVVIEWPROJ;

float4x4 WorldViewProj : WORLDVIEWPROJ;

float time : TIME;
float sin_time : SIN_TIME;
float cos_time : COS_TIME;
float tan_time : TAN_TIME;

#if NbBones > 0
float4x3 SkinBoneMatrix3[NbBones] : SKINBONEMATRIX3;
#endif

const float4 MaterialDiffuse : MATERIALDIFFUSE;
const float4 MaterialAmbient : MATERIALAMBIENT;
const float4 MaterialSpecular : MATERIALSPECULAR;
const float4 MaterialEmissive : MATERIALEMISSIVE;
const float MaterialPower : MATERIALPOWER;
const float3 EyePos : EYEPOS;
const float3 EyeDir : EYEDIR;
const float3 EyeUp : EYEUP;
static const float BitDepth = 16777216; // 24bits => (1<<24) = 16777216, 16bits => (1<<16) = 65536
static const float3 Luminance = float3(0.299f,0.587f,0.114f);
static const float fShadowDepthOffset = -0.002f;

float3 LightDir : WorldDirection
<
    string VarType = "Object";
    string Object = "DirectionalLight";
    int ObjectIndex = 0;
>;

float3 LightColor : Diffuse
<
    string VarType = "Object";
    string Object = "DirectionalLight";
    int ObjectIndex = 0;
>;
static const bool AGBNormalMap = false;

struct PSOutput
{
    float4 vColor0 : COLOR0; 
#if UseMultipleRenderTarget > 0 
    float4 vColor1 : COLOR1;
#endif
};

#if UseMultipleRenderTarget > 1
struct PSOutput3Color
{
    float4 vColor0 : COLOR0;  
    float4 vColor1 : COLOR1;
    float4 vColor2 : COLOR2;
};

float4 UpdateMask(float fBlur, float fSSAO)
{
	float4 vColor2 = (float4)0.0;
	vColor2.r = fBlur;
	vColor2.g = fSSAO;
	return vColor2;
}

#endif

#endif
